﻿using UnityEngine;
using BDArmory;

namespace NorthKerbinMod
{
    class Shockwave : MonoBehaviour
    {
        KSPParticleEmitter shockParticles;
        public string shockModelPath;
        public float maxRadius;
        public float partSize;
        public float height;
        float rad = 0;
        float sizeConst = 0.01f;

        void Start()
        {
            GameObject shockModel = GameDatabase.Instance.GetModel(shockModelPath);
            GameObject shockCenter = Instantiate(shockModel);
            shockParticles = shockCenter.GetComponent<KSPParticleEmitter>();
            shockParticles.enabled = true;
            if (height > 0)
            {
                shockParticles.shape2D.x = 0;
                shockParticles.shape2D.y = 0;
            }
        }

        void FixedUpdate()
        {
            rad += 11;
            height -= 11;
            shockParticles.sizeGrow = 0.05f;
            if(rad < maxRadius && height <= 0)
            {
                shockParticles.shape2D += new Vector2(11, 11);
                shockParticles.shape2D.x -= sizeConst;
                shockParticles.shape2D.y -= sizeConst;
                shockParticles.Emit();
            }
        }
    }
}